import { BigNumber } from 'ethers';
export declare enum UniversalRouterVersion {
    V1_2 = "1.2",
    V2_0 = "2.0"
}
export declare type RouterConfig = {
    address: string;
    creationBlock: number;
};
declare type ChainConfig = {
    weth: string;
    routerConfigs: {
        [key in UniversalRouterVersion]: RouterConfig;
    };
};
export declare const CHAIN_CONFIGS: {
    [key: number]: ChainConfig;
};
export declare const UNIVERSAL_ROUTER_ADDRESS: (version: UniversalRouterVersion, chainId: number) => string;
export declare const UNIVERSAL_ROUTER_CREATION_BLOCK: (version: UniversalRouterVersion, chainId: number) => number;
export declare const WETH_ADDRESS: (chainId: number) => string;
export declare const CONTRACT_BALANCE: BigNumber;
export declare const ETH_ADDRESS = "0x0000000000000000000000000000000000000000";
export declare const E_ETH_ADDRESS = "0xeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee";
export declare const ZERO_ADDRESS = "0x0000000000000000000000000000000000000000";
export declare const MAX_UINT256: BigNumber;
export declare const MAX_UINT160: BigNumber;
export declare const SENDER_AS_RECIPIENT = "0x0000000000000000000000000000000000000001";
export declare const ROUTER_AS_RECIPIENT = "0x0000000000000000000000000000000000000002";
export {};
